/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xdefines.h
 * -----------------------------------------------------------------*/

#ifndef XDEFINES_H_INCLUDED
#define XDEFINES_H_INCLUDED

/* ******************************************************************

     Important Note!!

     You may have problems compiling code that depends on our
     definition of the HUGE ppc constant. Some compilers define
     HUGE to HUGE_VAL in their <math.h>. To avoid this, you should
     work with a private copy of <math.h> where you disable or
     delete the definition of the HUGE constant. It took me an
     afternoon to find out and fix it.

     **************************************************************** */


/*
_WIN32 is auto-defined by MS (WIN32 not)
*/

#if defined(_WIN32) && !defined(WIN32)
#    define WIN32
#endif

#if defined(_WIN64) && !defined(WIN64)
#    define WIN64
#endif

/* 
Note;    if you have a problem with the strict ANSI __ (double-underscore)
        then use _ (single-underscore). i.e. _export instead of __export 
*/

#undef EXPORT
#undef LOADDS
#undef HUGE
#undef far

#if defined(WIN32) || defined(WIN64)
#    ifdef _MSC_VER        /* microsoft Win32 compilers only */
#        ifdef BEST_SUPPORT    
#            define EXPORT _stdcall
#        else
#            define EXPORT __declspec(dllexport)
#        endif
#    else
#        define EXPORT __export
#    endif
#    define LOADDS
#    define HUGE
#    define far

#elif defined DOS        /* dos or win16 */
#    define EXPORT __export    
#    define LOADDS __loadds
#    define HUGE __huge
#    define far    _far

#elif defined DOSW32  /* WATCOM DOS/4GW for 32bit */
#    define EXPORT __export
#    define LOADDS __loadds
#    define HUGE __huge
#    define far __far
/* no compiler warnings for 'defined but not referrenced */
#    pragma off (unreferenced);
    
#else
#    define EXPORT
#    define LOADDS
#    define HUGE
#    define far
#endif


#define CLI


#endif /* XDEFINES_H_INCLUDED */

